// Image Slide Module

export default class ImageSlide {
  #imageSlide = null;
  #numSlide = 0;
  #slideNow = 0;
  #slidePrev = 0;
  #slideNext = 0;
  #slideFirst = 1;
  #timerId = null;
  #timerInterval = 3000;
  #isTimerOn = false;

  constructor(selector, options) {
    this.#imageSlide = typeof(selector) === 'string' ? document.querySelector(selector) : selector;
    console.log(this.#imageSlide);
    this.#numSlide = this.#imageSlide.querySelectorAll('div.slide > ul > li').length;
    this.#slideFirst = (options !== undefined && options.slideFirst !== undefined) ? options.slideFirst : this.#slideFirst;
    this.#timerInterval = (options !== undefined && options.timerInterval !== undefined) ? options.timerInterval : this.#timerInterval;
    this.#isTimerOn = (options !== undefined && options.isTimerOn !== undefined) ? options.isTimerOn : this.#isTimerOn;
    this.#setInitial();
    this.#showSlide(this.#slideFirst);
    this.#setEvent();
  }

  #setInitial() {
    for (let i = 0; i < this.#numSlide; i++) {
      this.#imageSlide.querySelector('div.indicator > ul').insertAdjacentHTML(
        'beforeend',
        `<li><a href="#">${i + 1}번 슬라이드<span class="sr-only">현재슬라이드</span></a></li>\n`
      );
    }
    if (this.#isTimerOn === true) {
      this.#imageSlide.classList.add('play');
    } else if (this.#isTimerOn == false) {
      this.#imageSlide.classList.add('pause');
    }
  }

  #setEvent() {
    // n번째 슬라이드 표시
    this.#imageSlide.querySelectorAll('div.indicator > ul > li > a').forEach((btn, i) => {
      btn.addEventListener('click', () => {
        this.#showSlide(i + 1);
      }, false);
    });

    // 이전 슬라이드 표시
    this.#imageSlide.querySelector('div.control a.prev').addEventListener('click', () => {
      this.#showSlide(this.#slidePrev);
    }, false);

    // 다음 슬라이드 표시
    this.#imageSlide.querySelector('div.control a.next').addEventListener('click', () => {
      this.#showSlide(this.#slideNext);
    }, false);

    // 타이머 시작
    this.#imageSlide.querySelector('div.control a.play').addEventListener('click', () => {
      this.#playTimer();
    }, false);

    // 타이머 정지
    this.#imageSlide.querySelector('div.control a.pause').addEventListener('click', () => {
      this.#pauseTimer();
    }, false);
  }

  #playTimer() {
    this.#timerId = setTimeout(() => {this.#showSlide(this.#slideNext);}, this.#timerInterval);
    this.#isTimerOn = true;
    this.#imageSlide.classList.remove('pause');
    this.#imageSlide.classList.add('play');
  }

  #pauseTimer() {
    clearTimeout(this.#timerId);
    this.#isTimerOn = false;
    this.#imageSlide.classList.remove('play');
    this.#imageSlide.classList.add('pause');
  }

  #showSlide(n) {
    clearTimeout(this.#timerId);
    this.#imageSlide.querySelectorAll('div.slide > ul > li').forEach(slide => {
      slide.classList.remove('on');
    });
    this.#imageSlide.querySelectorAll('div.slide > ul > li')[n - 1].classList.add('on');
    this.#imageSlide.querySelectorAll('div.indicator > ul > li').forEach(slide => {
      slide.classList.remove('on');
    });
    this.#imageSlide.querySelectorAll('div.indicator > ul > li')[n - 1].classList.add('on');
    this.#slideNow = n;
    this.#slidePrev = (this.#slideNow - 1) < 1 ? this.#numSlide : this.#slideNow - 1;
    this.#slideNext = (this.#slideNow + 1) > this.#numSlide ? 1 : this.#slideNow + 1;
    // console.log(slidePrev, slideNow, slideNext);
    if (this.#isTimerOn === true) this.#timerId = setTimeout(() => {this.#showSlide(this.#slideNext);}, this.#timerInterval);
  }

  showPrev() {
    this.#showSlide(this.#slidePrev);
  }

  showNext() {
    this.#showSlide(this.#slideNext);
  }

}







